/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import org.joget.ai.agent.model.AgentEnhancerAbstract;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.Traceable;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.workflow.model.WorkflowAssignment;
import org.joget.workflow.model.service.WorkflowManager;

public class StoreToVariableAgentEnhancer
extends AgentEnhancerAbstract {
    public String getName() {
        return "StoreToVariableAgentEnhancer";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-hdd\"></i>";
    }

    @Override
    public String getInfoTemplate() {
        String label = AppPluginUtil.getMessage((String)"storeToVariable.variable", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + label + "</dt><dd>${properties.variable}</dd></dl></div>";
    }

    @Override
    @Traceable
    public String enhance(AgentLLM llm, LLMConfig config, Response response) throws AgentException {
        String variable = this.getPropertyString("variable");
        if (variable != null && !variable.isEmpty()) {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            WorkflowAssignment wfAssignment = (WorkflowAssignment)this.getProperty("workflowAssignment");
            if (wfAssignment != null) {
                workflowManager.activityVariable(wfAssignment.getActivityId(), variable, (Object)response.getContent());
            }
        }
        return "{\"result\": \"Successfully store data\"}";
    }
}

