/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.util.HashMap;
import java.util.Map;
import org.joget.ai.agent.model.AgentEnhancerAbstract;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.Traceable;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.JsonApiUtil;
import org.joget.apps.form.model.FormRow;
import org.joget.apps.form.model.FormRowSet;
import org.joget.commons.util.LogUtil;
import org.joget.workflow.model.WorkflowAssignment;
import org.json.JSONObject;

public class StoreToFormAgentEnhancer
extends AgentEnhancerAbstract {
    public String getName() {
        return "StoreToFormAgentEnhancer";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-hdd\"></i>";
    }

    @Override
    public String getInfoTemplate() {
        String label = AppPluginUtil.getMessage((String)"storeToForm.formDefId", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + label + "</dt><dd>${properties.formDefId}</dd></dl></div>";
    }

    @Override
    @Traceable
    public String enhance(AgentLLM llm, LLMConfig config, Response response) throws AgentException {
        String formDefId = this.getPropertyString("formDefId");
        if (formDefId != null && !formDefId.isEmpty()) {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            String type = this.getPropertyString("type");
            if ("json".equals(type)) {
                this.handleJsonContent(appDef, formDefId, response);
            } else {
                String fieldId;
                WorkflowAssignment wfAssignment;
                String recordId = this.getPropertyString("recordId");
                if (recordId.isEmpty() && (wfAssignment = (WorkflowAssignment)this.getProperty("workflowAssignment")) != null) {
                    recordId = appService.getOriginProcessId(wfAssignment.getProcessId());
                }
                if (recordId != null && !recordId.isEmpty() && !(fieldId = this.getPropertyString("fieldId")).isEmpty()) {
                    FormRowSet frs = new FormRowSet();
                    FormRow row = new FormRow();
                    row.put((Object)fieldId, (Object)response.getContent());
                    frs.add((Object)row);
                    appService.storeFormData(appDef.getAppId(), appDef.getVersion().toString(), formDefId, frs, recordId);
                }
            }
        }
        return "{\"result\": \"Successfully store data\"}";
    }

    public void handleJsonContent(AppDefinition appDef, String formDefId, Response response) {
        try {
            Object jsonResponse = response.getContent();
            if (jsonResponse != null && !((String)jsonResponse).isEmpty()) {
                if (((String)(jsonResponse = ((String)jsonResponse).trim())).startsWith("[") && ((String)jsonResponse).endsWith("]")) {
                    jsonResponse = "{ \"response\" : " + (String)jsonResponse + " }";
                } else if (!((String)jsonResponse).startsWith("{") && !((String)jsonResponse).endsWith("}")) {
                    jsonResponse = "{ \"response\" : \"" + (String)jsonResponse + "\" }";
                }
                Map results = JsonApiUtil.getJsonObjectMap((JSONObject)new JSONObject((String)jsonResponse));
                if (results != null) {
                    String multirowBaseObjectName = this.getPropertyString("multirowBaseObject");
                    FormRowSet rows = new FormRowSet();
                    if (!multirowBaseObjectName.isEmpty()) {
                        Object[] baseObjectArray;
                        rows.setMultiRow(true);
                        Object temp = JsonApiUtil.getObjectFromMap((String)multirowBaseObjectName, (Map)results);
                        if (temp != null && temp.getClass().isArray() && (baseObjectArray = (Object[])temp).length > 0) {
                            for (Object rowObj : baseObjectArray) {
                                rows.add((Object)this.getRow((Map)rowObj, multirowBaseObjectName));
                            }
                        }
                    } else {
                        rows.add((Object)this.getRow(results, ""));
                    }
                    if (!rows.isEmpty()) {
                        AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                        appService.storeFormData(appDef.getId(), appDef.getVersion().toString(), formDefId, rows, null);
                    }
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
    }

    protected FormRow getRow(Map object, String multirowBaseObjectName) {
        Object[] fieldMapping;
        FormRow r = new FormRow();
        for (Object o : fieldMapping = (Object[])this.getProperty("fieldMapping")) {
            Object value;
            HashMap mapping = (HashMap)o;
            String fieldName = mapping.get("field").toString();
            String jsonObjectName = mapping.get("jsonObjectName").toString();
            if (!multirowBaseObjectName.isEmpty()) {
                jsonObjectName = jsonObjectName.replace(multirowBaseObjectName + ".", "");
            }
            if ((value = JsonApiUtil.getObjectFromMap((String)jsonObjectName, (Map)object)) == null) {
                value = jsonObjectName;
            }
            if ("id".equals(fieldName)) {
                r.setId(value.toString());
                continue;
            }
            r.put((Object)fieldName, (Object)value.toString());
        }
        String primaryKey = StoreToFormAgentEnhancer.getEffectivePrimaryKey(object, multirowBaseObjectName, this.getPropertyString("primaryKey"), (WorkflowAssignment)this.getProperty("workflowAssignment"));
        if (primaryKey != null && !primaryKey.isEmpty()) {
            r.setId(primaryKey);
        }
        return r;
    }

    protected static String getEffectivePrimaryKey(Map object, String multirowBaseObjectName, String idFieldRaw, WorkflowAssignment wfAssignment) {
        if (idFieldRaw == null || idFieldRaw.isEmpty()) {
            if (wfAssignment != null) {
                AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                String processId = appService.getOriginProcessId(wfAssignment.getProcessId());
                return processId != null ? processId : "";
            }
            return "";
        }
        String idField = multirowBaseObjectName != null && !multirowBaseObjectName.isEmpty() ? idFieldRaw.replace(multirowBaseObjectName + ".", "") : idFieldRaw;
        Object id = JsonApiUtil.getObjectFromMap((String)idField, (Map)object);
        if (id != null && !id.toString().isEmpty()) {
            return id.toString();
        }
        return id != null ? id.toString() : idField;
    }
}

