/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentLLMAbstract;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Response;
import org.joget.ai.agent.model.Traceable;
import org.joget.ai.agent.model.URLUtility;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.workflow.model.service.WorkflowUserManager;

public class OpenAIAgentLLM
extends AgentLLMAbstract {
    public String getName() {
        return "OpenAIAgentLLM";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-user-secret\"></i>";
    }

    @Override
    public AgentLLM.Type getLLMType() {
        return AgentLLM.Type.OPENAI;
    }

    protected String getUrl() {
        String configuredUrl = this.getPropertyString("apiUrl");
        String openAiDefaultUrl = AppPluginUtil.getMessage((String)"openAi.defaultapiUrl", (String)this.getClassName(), (String)"messages/agentPlugins");
        return URLUtility.validateApiUrl(configuredUrl, openAiDefaultUrl);
    }

    protected void presetConfig(LLMConfig config) {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        config.put("model", this.getPropertyString("model"));
        config.put("user", wum.getCurrentUsername());
    }

    @Override
    @Traceable
    public Response getResponse(LLMConfig config, Messages messages, Functions functions) throws AgentException {
        this.presetConfig(config);
        return this.callService(this.getUrl(), config, messages, functions);
    }
}

