/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentPromptAbstract;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Traceable;
import org.joget.apps.app.dao.DatalistDefinitionDao;
import org.joget.apps.app.model.DatalistDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.datalist.model.DataList;
import org.joget.apps.datalist.model.DataListCollection;
import org.joget.apps.datalist.model.DataListColumn;
import org.joget.apps.datalist.service.DataListDecorator;
import org.joget.apps.datalist.service.DataListService;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.StringUtil;

public class ListDataAgentPrompt
extends AgentPromptAbstract {
    public String getName() {
        return "ListDataAgentPrompt";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-table\"></i>";
    }

    @Override
    public String getInfoTemplate() {
        String listLabel = AppPluginUtil.getMessage((String)"userview.datalistmenu.listId", (String)this.getClassName(), (String)"messages/agentPlugins");
        String label = AppPluginUtil.getMessage((String)"listdata.explanation", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + listLabel + "</dt><dd>${properties.listDefId}</dd><dt>" + label + "</dt><dd><pre>${properties.explanation}</pre></dd></dl></div>";
    }

    @Override
    @Traceable
    public void generate(AgentLLM llm, LLMConfig config, Messages messages) throws AgentException {
        try {
            DatalistDefinitionDao datalistDefinitionDao = (DatalistDefinitionDao)AppUtil.getApplicationContext().getBean("datalistDefinitionDao");
            DatalistDefinition datalistDefinition = (DatalistDefinition)datalistDefinitionDao.loadById(this.getPropertyString("listDefId"), AppUtil.getCurrentAppDefinition());
            if (datalistDefinition != null) {
                String json = datalistDefinition.getJson();
                DataListService dataListService = (DataListService)AppUtil.getApplicationContext().getBean("dataListService");
                DataList dataList = dataListService.fromJson(json);
                String table = this.generateTable(dataList);
                messages.add(new Message(Message.Role.SYSTEM, this.getPropertyString("explanation") + "\n\n" + table));
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            throw new AgentException(e.getLocalizedMessage());
        }
    }

    protected String generateTable(DataList dataList) {
        StringBuilder markdown = new StringBuilder();
        DataListCollection results = dataList.getRows();
        StringBuilder seperator = new StringBuilder();
        markdown.append("| ");
        seperator.append("| ");
        for (DataListColumn c : dataList.getColumns()) {
            if (c.isHidden()) continue;
            markdown.append(StringUtil.stripAllHtmlTag((String)c.getLabel()));
            markdown.append(" | ");
            seperator.append(" --- | ");
        }
        markdown.append("\n");
        seperator.append("\n");
        markdown.append(seperator.toString());
        DataListDecorator decorator = new DataListDecorator(dataList);
        for (Object row : results) {
            markdown.append("| ");
            for (DataListColumn column : dataList.getColumns()) {
                if (column.isHidden()) continue;
                String columnName = column.getName();
                Object value = DataListService.evaluateColumnValueFromRow(row, (String)columnName);
                String formattedValue = decorator.formatColumn(column, row, value);
                markdown.append(StringUtil.stripAllHtmlTag((String)formattedValue));
                markdown.append(" | ");
            }
            markdown.append("\n");
        }
        return markdown.toString();
    }
}

