/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentPromptAbstract;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Traceable;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.service.FormERD;
import org.joget.commons.util.DynamicDataSourceManager;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.StringUtil;
import org.json.JSONObject;

public class FormDataSchemaAgentPrompt
extends AgentPromptAbstract {
    public String getName() {
        return "FormDataSchemaAgentPrompt";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-table\"></i>";
    }

    @Override
    public String getInfoTemplate() {
        String label = AppPluginUtil.getMessage((String)"formDataSchema.additionalInfo", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + label + "</dt><dd><pre>${properties.additionalInfo}</pre></dd></dl></div>";
    }

    @Override
    @Traceable
    public void generate(AgentLLM llm, LLMConfig config, Messages messages) throws AgentException {
        try {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            Cache cache = (Cache)AppUtil.getApplicationContext().getBean("fluCache");
            String cacheKey = DynamicDataSourceManager.getCurrentProfile() + "_" + appDef.getAppId() + "_" + appDef.getVersion().toString() + "_FormDataSchemaAgentPrompt";
            Element element = cache.get((Serializable)((Object)cacheKey));
            String schema = null;
            Long lastModified = null;
            if (appDef.getDateModified() != null) {
                lastModified = appDef.getDateModified().getTime();
            }
            if (element != null && lastModified != null && element.getCreationTime() < lastModified) {
                cache.remove((Serializable)((Object)cacheKey));
                element = null;
            }
            if (element == null) {
                FormERD erd = new FormERD(appDef);
                schema = this.parseResults(erd.getJson());
                element = new Element((Serializable)((Object)cacheKey), (Serializable)((Object)schema));
                cache.put(element);
            } else {
                schema = (String)((Object)element.getValue());
            }
            messages.add(new Message(Message.Role.SYSTEM, schema + "\n\n" + this.getPropertyString("additionalInfo")));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            throw new AgentException(e.getLocalizedMessage());
        }
    }

    protected String parseResults(String json) {
        StringBuilder relationship = new StringBuilder();
        relationship.append("## ").append(AppPluginUtil.getMessage((String)"formDataSchema.tableRelationship", (String)this.getClassName(), (String)"messages/agentPlugins")).append("\n");
        StringBuilder schema = new StringBuilder();
        schema.append("## ").append(AppPluginUtil.getMessage((String)"formDataSchema.tableSchema", (String)this.getClassName(), (String)"messages/agentPlugins")).append("\n");
        JSONObject erd = new JSONObject(json);
        if (erd.has("entities")) {
            JSONObject entities = erd.getJSONObject("entities");
            Iterator keys = entities.keys();
            while (keys.hasNext()) {
                String tableName = (String)keys.next();
                this.writeEntity(tableName, entities.getJSONObject(tableName), relationship, schema);
            }
        }
        return relationship.toString() + "\n\n" + schema.toString();
    }

    protected void writeEntity(String tableName, JSONObject entity, StringBuilder relationship, StringBuilder schema) {
        JSONObject fields;
        schema.append("### ").append(AppPluginUtil.getMessage((String)"formDataSchema.table", (String)this.getClassName(), (String)"messages/agentPlugins")).append(" : `").append(tableName).append("`\n");
        if (entity.has("forms") && !entity.getJSONObject("forms").keySet().isEmpty()) {
            JSONObject forms = entity.getJSONObject("forms");
            schema.append("**").append(AppPluginUtil.getMessage((String)"formDataSchema.usedBy", (String)this.getClassName(), (String)"messages/agentPlugins")).append("**: ");
            Iterator keys = forms.keys();
            boolean isFirst = true;
            while (keys.hasNext()) {
                if (!isFirst) {
                    schema.append(", ");
                }
                String formId = (String)keys.next();
                schema.append(forms.getString(formId));
                isFirst = false;
            }
        }
        schema.append("**").append(AppPluginUtil.getMessage((String)"formDataSchema.columns", (String)this.getClassName(), (String)"messages/agentPlugins")).append("**:\n");
        schema.append("| ").append(AppPluginUtil.getMessage((String)"formDataSchema.column", (String)this.getClassName(), (String)"messages/agentPlugins")).append(" | ").append(AppPluginUtil.getMessage((String)"formDataSchema.description", (String)this.getClassName(), (String)"messages/agentPlugins")).append(" |\n");
        schema.append("|  --- |  --- |\n");
        this.writeField("id", AppPluginUtil.getMessage((String)"formDataSchema.field.id", (String)this.getClassName(), (String)"messages/agentPlugins"), schema);
        this.writeField("dateCreated", AppPluginUtil.getMessage((String)"formDataSchema.field.dateCreated", (String)this.getClassName(), (String)"messages/agentPlugins"), schema);
        this.writeField("createdBy", AppPluginUtil.getMessage((String)"formDataSchema.field.createdBy", (String)this.getClassName(), (String)"messages/agentPlugins"), schema);
        this.writeField("createdByName", AppPluginUtil.getMessage((String)"formDataSchema.field.createdByName", (String)this.getClassName(), (String)"messages/agentPlugins"), schema);
        this.writeField("dateModified", AppPluginUtil.getMessage((String)"formDataSchema.field.dateModified", (String)this.getClassName(), (String)"messages/agentPlugins"), schema);
        this.writeField("modifiedBy", AppPluginUtil.getMessage((String)"formDataSchema.field.modifiedBy", (String)this.getClassName(), (String)"messages/agentPlugins"), schema);
        this.writeField("modifiedByName", AppPluginUtil.getMessage((String)"formDataSchema.field.modifiedByName", (String)this.getClassName(), (String)"messages/agentPlugins"), schema);
        HashSet<CallSite> columns = new HashSet<CallSite>();
        JSONObject ownBy = entity.getJSONObject("ownBy");
        if (!ownBy.keySet().isEmpty()) {
            Iterator keys = ownBy.keys();
            while (keys.hasNext()) {
                JSONObject fk = ownBy.getJSONObject((String)keys.next());
                String fieldId = "c_" + fk.getString("fieldId");
                String desc = AppPluginUtil.getMessage((String)"formDataSchema.foreignKey", (String)this.getClassName(), (String)"messages/agentPlugins");
                desc = desc.replaceAll(StringUtil.escapeRegex((String)"{0}"), StringUtil.escapeRegex((String)(fk.getString("entity") + "." + fk.getString("entityFieldId"))));
                this.writeField(fieldId, desc, schema);
                columns.add((CallSite)((Object)fieldId));
            }
        }
        if (!(fields = entity.getJSONObject("fields")).keySet().isEmpty()) {
            Iterator keys = fields.keys();
            while (keys.hasNext()) {
                String label;
                JSONObject field = fields.getJSONObject((String)keys.next());
                String fieldId = "c_" + field.getString("id");
                if (columns.contains(fieldId)) continue;
                String string = label = field.has("label") ? field.getString("label") : "";
                if (label.isEmpty()) {
                    label = fieldId.substring(2).replaceAll("[_-]", " ");
                }
                this.writeField(fieldId, label, schema);
                columns.add((CallSite)((Object)fieldId));
            }
        }
        schema.append("\n");
        JSONObject hasMany = entity.getJSONObject("hasMany");
        if (!hasMany.keySet().isEmpty()) {
            String hasManyDesc = AppPluginUtil.getMessage((String)"formDataSchema.hasMany", (String)this.getClassName(), (String)"messages/agentPlugins");
            Iterator keys = hasMany.keys();
            while (keys.hasNext()) {
                JSONObject r = hasMany.getJSONObject((String)keys.next());
                String desc = hasManyDesc.replaceAll(StringUtil.escapeRegex((String)"{0}"), StringUtil.escapeRegex((String)tableName));
                desc = desc.replaceAll(StringUtil.escapeRegex((String)"{1}"), StringUtil.escapeRegex((String)r.getString("entity")));
                relationship.append("- ").append(desc).append("\n");
            }
        }
    }

    protected void writeField(String fieldId, String fieldDesc, StringBuilder schema) {
        schema.append("| ").append(fieldId).append(" | ").append(fieldDesc).append(" |\n");
    }
}

