/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.util.Map;
import org.joget.ai.agent.AgentBuilder;
import org.joget.ai.agent.lib.StoreToFormAgentEnhancer;
import org.joget.ai.agent.model.Response;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.JsonApiUtil;
import org.joget.apps.form.model.FormRow;
import org.joget.apps.form.model.FormRowSet;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.DefaultApplicationPlugin;
import org.joget.workflow.model.WorkflowAssignment;
import org.joget.workflow.model.service.WorkflowManager;
import org.json.JSONObject;

public class AgentProcessTool
extends DefaultApplicationPlugin {
    public String getName() {
        return "AgentProcessTool";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    public Object execute(Map properties) {
        WorkflowAssignment wfAssignment = (WorkflowAssignment)properties.get("workflowAssignment");
        try {
            Object agent = this.getProperty("agent");
            Response response = AgentBuilder.runAgent(agent, wfAssignment);
            this.storeToForm(properties, wfAssignment, response);
            this.storeToVariable(properties, wfAssignment, response);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        return null;
    }

    protected void storeToForm(Map properties, WorkflowAssignment wfAssignment, Response response) {
        String formDefId = (String)this.getProperty("formDefId");
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
        String type = (String)this.getProperty("type");
        if ("json".equalsIgnoreCase(type)) {
            Object[] fieldMapping = (Object[])this.getProperty("fieldMapping");
            if (formDefId == null || formDefId.trim().isEmpty() || fieldMapping == null || fieldMapping.length == 0) {
                return;
            }
            this.handleJsonContent(appService, appDef, properties, formDefId, response);
        } else {
            String fieldId = (String)this.getProperty("fieldId");
            String recordId = (String)this.getProperty("recordId");
            if ((recordId == null || recordId.isEmpty()) && wfAssignment != null) {
                recordId = appService.getOriginProcessId(wfAssignment.getProcessId());
            }
            if (recordId != null && !recordId.isEmpty() && fieldId != null && !fieldId.isEmpty()) {
                FormRow row = new FormRow();
                row.put((Object)fieldId, (Object)response.getContent());
                FormRowSet rows = new FormRowSet();
                rows.add((Object)row);
                appService.storeFormData(appDef.getAppId(), appDef.getVersion().toString(), formDefId, rows, recordId);
            }
        }
    }

    protected void handleJsonContent(AppService appService, AppDefinition appDef, Map properties, String formDefId, Response response) {
        try {
            Object content = response.getContent();
            if (content == null || ((String)content).trim().isEmpty()) {
                return;
            }
            if (((String)(content = ((String)content).trim())).startsWith("[") && ((String)content).endsWith("]")) {
                content = "{\"response\":" + (String)content + "}";
            } else if (!((String)content).startsWith("{") && !((String)content).endsWith("}")) {
                content = "{\"response\":\"" + (String)content + "\"}";
            }
            Map results = JsonApiUtil.getJsonObjectMap((JSONObject)new JSONObject((String)content));
            if (results == null) {
                return;
            }
            String baseObject = (String)this.getProperty("multirowBaseObject");
            FormRowSet rowSet = new FormRowSet();
            if (baseObject != null && !baseObject.isEmpty()) {
                Object[] array = (Object[])JsonApiUtil.getObjectFromMap((String)baseObject, (Map)results);
                if (array != null) {
                    rowSet.setMultiRow(true);
                    for (Object rowObj : array) {
                        rowSet.add((Object)this.buildRow((Map)rowObj, baseObject));
                    }
                }
            } else {
                rowSet.add((Object)this.buildRow(results, ""));
            }
            if (!rowSet.isEmpty()) {
                appService.storeFormData(appDef.getId(), appDef.getVersion().toString(), formDefId, rowSet, null);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
    }

    protected FormRow buildRow(Map object, String baseObjectName) {
        Object[] fieldMapping;
        FormRow row = new FormRow();
        for (Object o : fieldMapping = (Object[])this.getProperty("fieldMapping")) {
            Object value;
            Map mapping = (Map)o;
            String field = (String)mapping.get("field");
            String jsonName = (String)mapping.get("jsonObjectName");
            if (baseObjectName != null && !baseObjectName.isEmpty()) {
                jsonName = jsonName.replace(baseObjectName + ".", "");
            }
            if ((value = JsonApiUtil.getObjectFromMap((String)jsonName, (Map)object)) == null) {
                value = jsonName;
            }
            if ("id".equals(field)) {
                row.setId(value.toString());
                continue;
            }
            row.put((Object)field, (Object)value.toString());
        }
        String primaryKey = StoreToFormAgentEnhancer.getEffectivePrimaryKey(object, baseObjectName, this.getPropertyString("primaryKey"), (WorkflowAssignment)this.getProperty("workflowAssignment"));
        if (primaryKey != null && !primaryKey.isEmpty()) {
            row.setId(primaryKey);
        }
        return row;
    }

    protected void storeToVariable(Map properties, WorkflowAssignment wfAssignment, Response response) {
        if (wfAssignment == null) {
            return;
        }
        String variable = (String)this.getProperty("variable");
        if (variable != null && !variable.isEmpty()) {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            workflowManager.activityVariable(wfAssignment.getActivityId(), variable, (Object)response.getContent());
        }
    }
}

