AgentTaskSection = {
    /**
     * To init and create default components used in the builder
     * 
     * @returns {undefined}
     */
    init: function() {
        var taskMeta = {
            builderTemplate: {
                render: AgentTaskSection.renderTask,
                afterRender: function(element, elementObj, component) {
                    element.removeAttr("data-cbuilder-noncontainer");
                },
                afterRemoved: function(parent, elementObj, component) {
                    var parentDataArray = $(parent).data("data")[component.builderTemplate.getParentDataHolder(elementObj, component)];
                    if (parentDataArray.length === 0) {
                        AgentTaskSection.addTask();
                    }
                },
                getLabel: function(data, component) {
                    return get_cbuilder_msg('agentbuilder.task');
                },
                customPasteData: AgentTaskSection.pasteTask,
                parentContainerAttr: 'tasks',
                parentDataHolder: 'tasks',
                supportStyle: false
            }
        };

        var properties = [
            {
                title: get_cbuilder_msg('agentbuilder.configTask'),
                properties: [
                    {
                        name: "label",
                        label: get_cbuilder_msg('agentbuilder.taskName'),
                        type: "textfield",
                        required: "True"
                    }
                ]
            }
        ];

        CustomBuilder.initPaletteElement("", "task", "", null, properties, null, false, "", taskMeta);
    },
    
    
     /**
     * Rendering a task to canvas
     * 
     * @param {type} element
     * @param {type} elementObj
     * @param {type} component
     * @param {type} callback
     * @returns {undefined}
     */
    renderTask: function(element, elementObj, component, callback) {
        element.html(''); //empty it
        element.addClass("agent-task");
        element.attr('data-cbuilder-iscontainer', '');
        element.append('<h5 class="agent-task-label">'+elementObj.properties.label+'</h5>');
        
        //render prompts
        element.append('<div class="agent-task-prompt-section"><div data-cbuilder-prompt data-cbuilder-iscontainer data-cbuilder-droparea-msg="'+get_cbuilder_msg('agentbuilder.promptArea')+'"></div></div>');
        if (elementObj.prompt) {
            AgentBuilder.renderElements(element.find('> .agent-task-prompt-section > div'), elementObj.prompt);
        }
        
        //render tools
        element.append('<div class="agent-task-tool-section"><div data-cbuilder-tool data-cbuilder-iscontainer data-cbuilder-droparea-msg="'+get_cbuilder_msg('agentbuilder.toolArea')+'"></div></div>');
        if (elementObj.tool) {
            AgentBuilder.renderElements(element.find('> .agent-task-tool-section > div'), elementObj.tool);
        }
        
        //render enhancers
        element.append('<div class="agent-task-enhancer-section"><div data-cbuilder-enhancer data-cbuilder-iscontainer data-cbuilder-droparea-msg="'+get_cbuilder_msg('agentbuilder.enhancerArea')+'"></div></div>');
        if (elementObj.enhancer) {
            AgentBuilder.renderElements(element.find('> .agent-task-enhancer-section > div'), elementObj.enhancer);
        }
        
        callback(element);
    },
    
    
    /**
     * Adding a new task
     * 
     * @returns {undefined}
     */
    addTask: function() {
        var self = CustomBuilder.Builder;
        
        self.component = self.getComponent("task");
        var classname = self.component.className;
        var properties = {
            "label": get_cbuilder_msg('agentbuilder.newTask')
        };
        var elementObj = {
            "properties": properties,
            "prompt": [
                {
                    "className": "org.joget.ai.agent.lib.TextPromptAgentPrompt",
                    "properties": {
                        "id": CustomBuilder.uuid(),
                        "prompt": "${query}"
                    }
                }
            ],
            "tool": [],
            "enhancer": []
        };
        self.updateElementId(elementObj);
        
        var parent = self.frameBody.find('.agent-canvas');
        var parentDataArray = $(parent).data("data").tasks;
        var newIndex = $.inArray($(self.selectedEl).data("data"), parentDataArray) + 1;
        parentDataArray.splice(newIndex, 0, elementObj);
        
        var temp = $('<div></div>');
        if (self.selectedEl) { //append new task after the selected task
            self.selectedEl.after(temp);
        } else {
            self.frameBody.find('.agent-tasks-section').append(temp);
        }
        
        self.renderElement(elementObj, temp, self.component, true);
        
        CustomBuilder.update();
    },
    
    /**
     * A callback method called from the default component.builderTemplate.decorateBoxActions method.
     * It used to add task action button when a task is selected
     * 
     * @param {type} element
     * @param {type} elementObj
     * @param {type} component
     * @param {type} box
     * @returns {undefined}
     */
    decorateBoxActions : function(element, elementObj, component, box) {
        var builder = CustomBuilder.Builder;
        if (component.className === "task") {
            $(box).find(".element-options").append('<a class="add-task-btn" title="'+get_cbuilder_msg("agentbuilder.addTask")+'"><i class="las la-plus"></i></a>');
            
            $(box).find(".element-bottom-actions").append('<a class="add-task-btn" href="" title="'+get_cbuilder_msg("agentbuilder.addTask")+'"><i class="las la-plus"></i></a>');
            
            $(box).find(".add-task-btn").off("click");
            $(box).find(".add-task-btn").on("click", function(event) {
                builder.boxActionSetElement(event);
                
                AgentTaskSection.addTask();
                
                event.preventDefault();
                return false;
            });
        }
    },
    
    /**
     * Update the childs element after pasting a task
     * 
     * @param {type} copiedObj
     * @param {type} copiedComponent
     * @returns {undefined}
     */
    pasteTask: function(copiedObj, copiedComponent) {
        AgentBuilder.updateElementsId(copiedObj.prompt);
        AgentBuilder.updateElementsId(copiedObj.tool);
        AgentBuilder.updateElementsId(copiedObj.enhancer);
    }
};