AgentBuilder = {
    
    /**
     * Init the builder with canvas & tools
     * 
     * @param {type} callback
     * @returns {undefined}
     */
    initBuilder: function (callback) {
        AgentBuilder.initDefaultComponent();
        
        CustomBuilder.Builder.init({
            "enableViewport": false,
            callbacks : {
                "decorateBoxActions" : "AgentTaskSection.decorateBoxActions",
                "parseDataToComponent" : "AgentBuilder.parseDataToComponent",
                "renderElement" : "AgentBuilder.ajaxRendering"
            }
        }, function() {
            var deferreds = [];
            
            AgentBuilder.initPalette(deferreds);
            
            CustomBuilder.Builder.setHead('<link data-datalist-style href="' + CustomBuilder.contextPath + '/plugin/org.joget.ai.agent.AgentBuilder/agentbuilder.css" rel="stylesheet" />');
            CustomBuilder.Builder.setHead('<link data-agent-style href="' + CustomBuilder.contextPath + '/plugin/org.joget.ai.agent.AgentBuilder/feature/agentSection/agentSection.css" rel="stylesheet" />');
            CustomBuilder.Builder.setHead('<link data-task-style href="' + CustomBuilder.contextPath + '/plugin/org.joget.ai.agent.AgentBuilder/feature/agentTaskSection/agentTaskSection.css" rel="stylesheet" />');
            CustomBuilder.Builder.setHead('<link data-datalist-style href="' + CustomBuilder.contextPath + '/plugin/org.joget.ai.agent.AgentBuilder/feature/Prompts/Prompts.css" rel="stylesheet" />');
            CustomBuilder.Builder.setHead('<link data-agent-style href="' + CustomBuilder.contextPath + '/plugin/org.joget.ai.agent.AgentBuilder/feature/LLMServices/LLMServices.css" rel="stylesheet" />');
            CustomBuilder.Builder.setHead('<link data-task-style href="' + CustomBuilder.contextPath + '/plugin/org.joget.ai.agent.AgentBuilder/feature/Enhancers/Enhancers.css" rel="stylesheet" />');
            CustomBuilder.Builder.setHead('<link data-datalist-style href="' + CustomBuilder.contextPath + '/plugin/org.joget.ai.agent.AgentBuilder/feature/Tools/Tool.css" rel="stylesheet" />');
            if (CustomBuilder.systemTheme === undefined) {
                CustomBuilder.systemTheme = $('body').attr("builder-theme");
            }
            if (CustomBuilder.systemTheme === 'dark') {
                CustomBuilder.Builder.setHead('<link data-userview-style href="' + CustomBuilder.contextPath + '/css/darkTheme.css" rel="stylesheet" />');
            }
            
            $.when.apply($, deferreds).then(function() {
                if (callback) {
                    callback();
                }
            });
        });
    },
    
    /**
     * Load and render the defintion in canvas
     * 
     * @param {type} data
     * @returns {undefined}
     */
    load: function (data) {
        CustomBuilder.Builder.load(data);
    },
    
    /**
     * To init and create default components used in the builder
     * 
     * @returns {undefined}
     */
    initDefaultComponent: function() {
        var meta = {
            builderTemplate : {
                'render' : AgentBuilder.renderCanvas,
                'draggable' : false,
                'movable' : false,
                'deletable' : false,
                'copyable' : false,
                'navigable' : false,
                'uneditable' : true,
                'supportProperties' : false,
                'supportStyle' : false,
                'childsContainerAttr' : 'tasks'
            }
        };
        CustomBuilder.initPaletteElement("", "org.joget.ai.agent.AgentBuilder", "", null, null, null, false, "", meta);

        // Init components from other files
        AgentSection.init();
        AgentTaskSection.init();
    },
    
    /**
     * Make an AJAX calls to retrieve all the palette components and populate it to palette
     * 
     * @param {type} deferreds
     * @returns {undefined}
     */
    initPalette: function(deferreds) {
        var wait = $.Deferred();
        deferreds.push(wait);
        
        $.ajax({
            url: CustomBuilder.contextPath + '/web/json/app/' + CustomBuilder.appId + '/' + CustomBuilder.appVersion + '/plugin/org.joget.ai.agent.AgentBuilder/service?action=elements',
            dataType: "json",
            success: function (response) {
                if (response !== null && response !== "") {
                    AgentBuilder.initComponents("llm", response.llms);
                    AgentBuilder.initComponents("prompt", response.prompts);
                    AgentBuilder.initComponents("tool", response.tools);
                    AgentBuilder.initComponents("enhancer", response.enhancers);
                }

                wait.resolve();
            }
        });
    },
    
    /**
     * Create the palette category and populate the components
     * 
     * @param {type} type
     * @param {type} components
     * @returns {undefined}
     */
    initComponents: function(type, components) {
        var category = get_cbuilder_msg('agentbuilder.'+type);
        CustomBuilder.createPaletteCategory(category);
        
        for (var i in components) {
            var c = components[i];
            AgentBuilder.initComponent(type, c, category);
        }
    },
    
    /**
     * Init and populate the palette components
     * 
     * @param {type} type
     * @param {type} component
     * @param {type} category
     * @returns {undefined}
     */
    initComponent: function(type, component, category) {
        var meta = {
            type : type,
            isAjaxRendering : component.isAjaxRendering,
            builderTemplate : {
                'getHtml' : AgentBuilder.populateProperties,
                'html' : '<div></div>',
                'parentContainerAttr' : type,
                'parentDataHolder' : type,
                'supportStyle' : false
            }
        };
        
        if (type === "llm") {
            meta.builderTemplate.html = '<div><dl><dt>'+get_cbuilder_msg('agentbuilder.model')+'</dt><dd>${properties.model}</dd></dl></div>';
        }
        
        //allow plugin to customise the bahaviour
        if (component.builderJavaScriptTemplate !== undefined && component.builderJavaScriptTemplate !== "") {
            try {
                var template = eval("["+component.builderJavaScriptTemplate+"]");
                meta.builderTemplate = $.extend(meta.builderTemplate, template[0]);
            } catch (err) {
                console.log(err);
            }
        }
        
        CustomBuilder.initPaletteElement(category, component.className, component.label, component.icon, component.propertyOptions, component.defaultProperties, true, "", meta);
    },
    
    /**
     * To prepare and render the canvas
     * 
     * @param {type} element
     * @param {type} elementObj
     * @param {type} component
     * @param {type} callback
     * @returns {undefined}
     */
    renderCanvas: function(element, elementObj, component, callback) {
        element.html(''); //empty it
        element.addClass('agent-canvas');
        
        //render agent
        if (elementObj.agent) {
            AgentBuilder.renderElements(element, [elementObj.agent]);
        }
        
        //render tasks
        element.append('<div class="agent-tasks-section" data-cbuilder-tasks data-cbuilder-iscontainer data-cbuilder-sort-horizontal></div>');
        if (elementObj.tasks) {
            AgentBuilder.renderElements(element.find('> .agent-tasks-section'), elementObj.tasks);
        }
        
        callback(element);
    },
    
    /**
     * To loop and rendering all the provided elements
     * 
     * @param {type} container
     * @param {type} elements
     * @returns {undefined}
     */
    renderElements : function(container, elements) {
        var self = CustomBuilder.Builder;
        
        for (var i in elements) {
            var childComponent = self.parseDataToComponent(elements[i]);
            if (childComponent !== undefined && childComponent !== null) {
                var temp = $('<div></div>');
                $(container).append(temp);
                self.renderElement(elements[i], temp, childComponent, false);
            }
        }
    },
    
    /**
     * Populate properties to the HTML template
     * 
     * @param {type} elementObj
     * @param {type} component
     * @returns {undefined}
     */
    populateProperties : function(elementObj, component) {
        var html = component.builderTemplate.html;
        
        var props = component.properties;
        if (elementObj) {
            if (component.isAjaxRendering) { //render using ajax if mark ajax rendering
                return undefined;
            }
            props = elementObj.properties;
        }
        
        if (props) {
            html = html.replace(/\$\{properties\.(\w+)\}/g, (match, key) => AgentBuilder.populatePropertyWithOptionLabel(key, props[key], props, component) || '');
        }
        
        //injecting type and label
        var wrapper = $('<div>').html(html);
        $(wrapper).find('> div').addClass('agent-element agent-element-'+component.type);
        $(wrapper).find('> div').prepend('<label><span>'+get_cbuilder_msg('agentbuilder.element.'+component.type)+'</span> '+component.label+'</label>');
        
        return wrapper.html();
    },
    
    /**
     * populate the value with option label if there is options
     * 
     * @param {type} key
     * @param {type} value
     * @param {type} component
     * @returns {undefined}
     */
    populatePropertyWithOptionLabel : function(key, value, props, component) {
        if (value) {
            //find the property field
            var field;
            var propertiesoptions = component.propertyOptions;
            for (var i = 0; i < propertiesoptions.length; i++) {
                var page = propertiesoptions[i];
                for (var j=0; j < page.properties.length; j++) {
                    if (page.properties[j].name === key) {
                        field = page.properties[j];
                        break;
                    }
                }
                if (field) {
                    break;
                }
            }
            
            //find and check is it options field
            if (field && (field.options || field.options_ajax)) {
                var options;

                //if it is ajax
                if (field.options_ajax) { 
                    //try get from the property panel
                    var id = $(".editor-panel-mode [name$='_"+key+"']").attr("id");
                    var url = PropertyEditor.Util.prevAjaxCalls[id + "::" + undefined];
                    if (url) {
                        var data = PropertyEditor.Util.cachedAjaxCalls[url] || (PropertyEditor.Util.timeCachedAjaxCalls[url] && PropertyEditor.Util.timeCachedAjaxCalls[url].data);
                        if (data) {
                            options = $.parseJSON(data);
                        }
                    } else { 
                        //if it is not after property panel saved, generate a url
                        url = field.options_ajax;
                        
                        if (field.options_ajax_on_change) {
                            var onChanges = field.options_ajax_on_change.split(";");
                            for (var i in onChanges) {
                                var fieldId = onChanges[i];
                                var param = fieldId;
                                if (fieldId.indexOf(":") !== -1) {
                                    param = fieldId.substring(0, fieldId.indexOf(":"));
                                    fieldId = fieldId.substring(fieldId.indexOf(":") + 1);
                                }

                                if (url.indexOf('?') !== -1) {
                                    url += "&";
                                } else {
                                    url += "?";
                                }
                                url +=  param + "=" + encodeURIComponent(props[fieldId]);
                            }
                        }
                        
                        url = url.replace('[CONTEXT_PATH]', CustomBuilder.contextPath);
                        url = url.replace('[APP_PATH]', CustomBuilder.appPath);
                    }
                    
                    if (url && !options) {
                        //required ajax call, populate later
                        var orgValue = value;
                        var callId = CustomBuilder.uuid();
                        value = "<span id=\""+callId+"\">"+value+"</span>";
                        
                        $.ajax({
                            url: url,
                            dataType: "text",
                            method: "POST",
                            success: function(data) {
                                var options = $.parseJSON(data);
                                var value = AgentBuilder.findOptionsLabel(options, orgValue);
                                CustomBuilder.Builder.frameBody.find("#"+callId).html(value);
                            }
                        });
                    }
                } else {
                    options = field.options;
                }

                //find label
                value = AgentBuilder.findOptionsLabel(options, value);
            }
        }
        
        //escape the # in value
        if (value && value.indexOf("#") !== -1) {
            value = value.replaceAll("#", "#<span class='dummyescape'></span>");
        }
        
        return value;
    },
    
    /**
     * Find the option label based on value 
     * @param {type} options
     * @param {type} value
     * @returns {undefined}
     */
    findOptionsLabel : function(options, value) {
        if (options) {
            for (var i = 0; i < options.length; i++) {
                if (options[i].value === value) {
                    return options[i].label;
                }
            }
        }
        return value;
    },
    
    /**
     * Using AJAX to retrieve the element info html and render to canvas
     * 
     * @param {type} element
     * @param {type} elementObj
     * @param {type} component
     * @param {type} callback
     * @returns {undefined}
     */
    ajaxRendering : function(element, elementObj, component, callback) {
        //load by ajax
        var jsonStr = JSON.encode(elementObj);
        CustomBuilder.cachedAjax({
            type: "POST",
            data: {"json": jsonStr },
            url: CustomBuilder.contextPath + '/web/json/app/' + CustomBuilder.appId + '/' + CustomBuilder.appVersion + '/plugin/org.joget.ai.agent.AgentBuilder/service?action=ajaxRendering',
            dataType : "text",
            beforeSend: function (request) {
               request.setRequestHeader(ConnectionManager.tokenName, ConnectionManager.tokenValue);
            },
            success: function(response) {
                var newElement = $(response);
                
                //injecting type and label
                $(newElement).addClass('agent-element agent-element-'+component.type);
                $(newElement).prepend('<label><span>'+get_cbuilder_msg('agentbuilder.element.'+component.type)+'</span> '+component.label+'</label>');

                $(element).replaceWith(newElement);
                callback(newElement);
            }
        });
    },
    
    /**
     * To return the custom agent & task component
     * 
     * @param {type} data
     * @returns {unresolved}
     */
    parseDataToComponent : function(data) {
        if (data.llm) {
            return CustomBuilder.Builder.getComponent("agent");
        } else if (data.tool) {
            return CustomBuilder.Builder.getComponent("task");
        }
        return null;
    },
    
    /**
     * Update all the id of the elements 
     * 
     * @param {type} elements
     * @returns {undefined}
     */
    updateElementsId: function(elements) {
        var self = CustomBuilder.Builder;
        if (elements) {
            for (var i in elements) {
                self.updateElementId(elements[i]);
            }
        }
    }
};
