{
    initialize: PropertyEditor.Type.ElementSelect.prototype.initialize,
    getData: PropertyEditor.Type.ElementSelect.prototype.getData,
    validate: PropertyEditor.Type.ElementSelect.prototype.validate,
    renderDefault: PropertyEditor.Type.ElementSelect.prototype.renderDefault,
    orgPageShown: PropertyEditor.Type.ElementSelect.prototype.pageShown,
    handleAjaxOptions: PropertyEditor.Type.ElementSelect.prototype.handleAjaxOptions,
    orgInitScripting: PropertyEditor.Type.ElementSelect.prototype.initScripting,
    getContainerClass: PropertyEditor.Type.ElementSelect.prototype.getContainerClass,
    renderPages: PropertyEditor.Type.ElementSelect.prototype.renderPages,
    renderPropertiesPages : PropertyEditor.Type.ElementSelect.prototype.renderPropertiesPages,
    getElementProperties: PropertyEditor.Type.ElementSelect.prototype.getElementProperties,
    getElementDefaultProperties: PropertyEditor.Type.ElementSelect.prototype.getElementDefaultProperties,
    removePages: PropertyEditor.Type.ElementSelect.prototype.removePages,
    remove: PropertyEditor.Type.ElementSelect.prototype.remove,
    renderField: function(){
        var html = '<select id="' + this.id + '" name="' + this.id + '" class="initChosen">';
        var valueString = "";
        if (this.value !== null && ((typeof this.value) === "string")) {
            var temp = this.value;
            this.value = {};
            this.value.className = temp;
        }
        if (this.value !== null) {
            valueString = this.value.className;
        }

        PropertyEditor.Util.retrieveOptionsFromCallback(this, this.properties);

        if (this.properties.options !== undefined && this.properties.options !== null) {
            $.each(this.properties.options, function(i, option) {
                var selected = "";
                if (valueString === option.value) {
                    selected = " selected";
                }
                html += '<option value="' + PropertyEditor.Util.escapeHtmlTag(option.value) + '"' + selected + '>' + PropertyEditor.Util.escapeHtmlTag(option.label) + '</option>';
            });
        }
        html += '</select>';
        
        if (thisObj.options.appPath !== undefined && thisObj.options.appPath !== "") {
            html += thisObj.builderLink();
        }
        
        /* add style */
        html += "<style>";
        html += ".agent_option{display: flex !important;}";
        html += ".agent_option .logo{height: 35px; width: 35px; display: flex !important; justify-content: center !important; align-items: center !important;}";
        html += ".agent_option .logo block{height: 100%; width: 100%; background-size: contain; background-repeat: no-repeat; display: block;}";
        html += ".agent_option .logo i{opacity:0.5; font-size:150%}";
        html += ".agent_option .meta{display:inline-block; padding-left: 1rem !important; width: calc(100% - 35px); box-sizing: border-box;}";
        html += ".agent_option .name{font-weight:500; display:block;}";
        html += ".agent_option .desc{font-size:75%; display:block;}";
        html += ".chosen-single .agent_option .logo{height: 20px; width: 20px;}";
        html += ".chosen-single .agent_option .desc{display:none;}";
        html += "</style>";
        
        return html;
    },
    builderLink: function() {
        var thisObj = this;
        
        var builder = "cbuilder/agent";
        
        var html = " <a class=\"builderAddNew\" data-type=\""+builder+"\" title=\""+get_peditor_msg('peditor.addNewElement')+"\"><i class=\"fas fa-plus-circle\"></i></i></a>";
        html += " <a href=\"\" target=\"_blank\" class=\"openbuilder\" data-type=\""+builder+"\" style=\"display:none;\" title=\""+get_peditor_msg('peditor.openBuilder')+"\"><i class=\"fas fa-external-link-alt\"></i></i></a>";
        
        return html;
    },
    initScripting: function() {
        var field = this;
        
        thisObj.orgInitScripting();
        
        /* showing html */
        $("#" + this.id)
        .off('chosen:showing_dropdown.updatelabel chosen:hiding_dropdown.updatelabel chosen:ready.updatelabel chosen:updated.updatelabel change.updatelabel keyup.updatelabel')
        .on('chosen:showing_dropdown.updatelabel chosen:hiding_dropdown.updatelabel chosen:ready.updatelabel chosen:updated.updatelabel change.updatelabel keyup.updatelabel', function() {
            $("#" + field.id).next().find(".chosen-results li, .chosen-single > span, .search-choice > span").each(function() {
                var html = $(this).html().replace(/&lt;/g, "<").replace(/&gt;/g, ">");
                var regex = new RegExp("\\[(.*)<em>(.*)\\]", "g");
                html = html.replace(regex, "[$1$2]");
                regex = new RegExp("\\[(.*)</em>(.*)\\]", "g");
                html = html.replace(regex, "[$1$2]");
                $(this).html(html);
            });
        });
        setTimeout(function() {
            $("#" + field.id).trigger("keyup");
        }, 100);
        
        if ($("#" + field.id + "_input a.openbuilder").length > 0) {
            var updateLink = function() {
                var value = $("#" + field.id).val();
                if (value !== "" && value !== undefined && value !== null) {
                    var builder = $("#" + field.id + "_input a.openbuilder").data("type");
                    var url = field.options.contextPath + "/web/console/app" + field.options.appPath + "/" + builder + "/design" + "/" + value;
                    
                    $("#" + field.id + "_input a.openbuilder").attr("href", url);
                    $("#" + field.id + "_input a.openbuilder").show();
                    $("#" + field.id + "_input").addClass("builder-link");
                } else {
                    $("#" + field.id + "_input a.openbuilder").hide();
                    $("#" + field.id + "_input").removeClass("builder-link");
                }
            };
            $("#" + field.id).off("change.builder");
            $("#" + field.id).on("change.builder", function() {
                updateLink();
            });
            updateLink();
        }
        
        if ($("#" + field.id + "_input a.builderAddNew").length > 0) {
            $("#" + field.id + "_input a.builderAddNew").off("click");
            $("#" + field.id + "_input a.builderAddNew").on("click", function(){
                var type = $(this).data("type");
                var url = CustomBuilder.contextPath + '/web/console/app' + CustomBuilder.appPath + '/' + type + '/create?builderMode=true';
                JPopup.show("navCreateNewDialog", url, {}, "");
                $('iframe#navCreateNewDialog').data('field', field);
            });
        }
    },
    addNewOption: function(id, label) {
        var field = this;
        $("#" + field.id).append('<option value="'+PropertyEditor.Util.escapeHtmlTag(id)+'">'+PropertyEditor.Util.escapeHtmlTag(label)+'</option>');
        $("#" + field.id).val(PropertyEditor.Util.escapeHtmlTag(id));
        
        $("#" + field.id).trigger("change");
        $("#" + field.id).trigger("chosen:updated");
        
        if (field.properties.options_ajax !== null && field.properties.options_ajax !== undefined && field.properties.options_ajax !== "") {
            //clear cache
            PropertyEditor.Util.clearAjaxOptionsCache(this);
        } else if (field.properties.options_callback_addoption !== undefined && field.properties.options_callback_addoption !== null && field.properties.options_callback_addoption !== "") {
            var func = PropertyEditor.Util.getFunction(field.properties.options_callback_addoption);
            if ($.isFunction(func)) {
                func(field.properties, {"value" : id, "label" : label});
            }
        }
    },
    pageShown: function() {
        thisObj.orgPageShown();
        
        $("#" + this.id).trigger("chosen:updated");
    }
}
