/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.Functions;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.ai.agent.model.Response;
import org.joget.commons.util.LogUtil;

public class JsonParser {
    public String getClassName() {
        return this.getClass().getName();
    }

    private String extractCodeFenceContent(String input) {
        if (input == null) {
            return null;
        }
        Pattern fence = Pattern.compile("(?s)```(?:\\s*([a-zA-Z0-9+-_]+)\\s*)?\\n?(.*?)\\n?```");
        Matcher m = fence.matcher(input);
        if (m.find()) {
            return m.group(2).trim();
        }
        return null;
    }

    private String extractFirstBalancedJsonSegment(String input) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        ArrayList<Integer> candidateStarts = new ArrayList<Integer>();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c != '{' && c != '[') continue;
            candidateStarts.add(i);
        }
        for (Integer startIdx : candidateStarts) {
            char openChar = input.charAt(startIdx);
            char closeChar = openChar == '{' ? (char)'}' : ']';
            int depth = 0;
            boolean inString = false;
            boolean escaped = false;
            for (int i = startIdx.intValue(); i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (escaped) {
                    escaped = false;
                    continue;
                }
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                if (ch == '\"') {
                    inString = !inString;
                    continue;
                }
                if (inString) continue;
                if (ch == openChar) {
                    ++depth;
                    continue;
                }
                if (ch != closeChar || --depth != 0) continue;
                return input.substring(startIdx, i + 1).trim();
            }
        }
        return null;
    }

    private void restorePlaceholders(JsonNode node) {
        block6: {
            block5: {
                if (node == null) {
                    return;
                }
                if (!node.isObject()) break block5;
                ObjectNode obj = (ObjectNode)node;
                ArrayList keys = new ArrayList();
                obj.fieldNames().forEachRemaining(keys::add);
                for (String key : keys) {
                    JsonNode child = obj.get(key);
                    if (child == null) continue;
                    if (child.isTextual()) {
                        String replaced = child.asText().replace("<<NEWLINE>>", "\n");
                        obj.put(key, replaced);
                        continue;
                    }
                    this.restorePlaceholders(child);
                }
                break block6;
            }
            if (!node.isArray()) break block6;
            ArrayNode arr = (ArrayNode)node;
            for (int i = 0; i < arr.size(); ++i) {
                JsonNode child = arr.get(i);
                if (child == null) continue;
                if (child.isTextual()) {
                    String replaced = child.asText().replace("<<NEWLINE>>", "\n");
                    arr.set(i, (JsonNode)new TextNode(replaced));
                    continue;
                }
                this.restorePlaceholders(child);
            }
        }
    }

    public String parseJsonContent(AgentLLM llm, LLMConfig config, String text, String prompt, Boolean retry) throws JsonProcessingException {
        JsonNode root;
        String jsonCandidate;
        if (text == null || text.isEmpty()) {
            return "";
        }
        int MAX_INPUT_SIZE = 0x3200000;
        if (text.getBytes(StandardCharsets.UTF_8).length > 0x3200000) {
            LogUtil.info((String)this.getClassName(), (String)String.format("Input too large (%d bytes). Skipping JSON extraction.", text.getBytes(StandardCharsets.UTF_8).length));
            return "";
        }
        String cleaned = this.extractCodeFenceContent(text);
        if (cleaned == null) {
            cleaned = text.trim();
        }
        if ((jsonCandidate = this.extractFirstBalancedJsonSegment(cleaned)) == null) {
            LogUtil.debug((String)this.getClassName(), (String)"No balanced JSON segment found.");
            return "";
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            root = mapper.readTree(jsonCandidate);
        }
        catch (JsonProcessingException e) {
            if (retry.booleanValue()) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("JSON parsing failed: " + e.getMessage()));
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("Retrying with LLM: " + jsonCandidate));
                prompt = (String)prompt + text;
                Messages messages = new Messages();
                messages.addMessage(Message.Role.USER.toString().toUpperCase(), (String)prompt);
                Functions functions = new Functions();
                Response llmResponse = llm.getResponse(config, messages, functions);
                String result = this.parseJsonContent(llm, config, llmResponse.getContent(), (String)prompt, false);
                return result;
            }
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("JSON parsing failed: " + e.getMessage()));
            return text;
        }
        this.restorePlaceholders(root);
        return mapper.writeValueAsString((Object)root);
    }
}

