/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.model;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.joget.ai.agent.model.JsonKey;
import org.joget.commons.util.LogUtil;
import org.json.JSONObject;

public final class HyperParameters {
    @JsonKey(value="model")
    private final String model;
    @JsonKey(value="temperature")
    private final Double temperature;
    @JsonKey(value="top_p")
    private final Double topP;
    @JsonKey(value="top_k")
    private final Integer topK;
    @JsonKey(value="frequency_penalty")
    private final Double frequencyPenalty;
    @JsonKey(value="presence_penalty")
    private final Double presencePenalty;
    @JsonKey(value="repetition_penalty")
    private final Double repetitionPenalty;
    @JsonKey(value="min_p")
    private final Double minP;
    @JsonKey(value="top_a")
    private final Double topA;
    @JsonKey(value="max_tokens")
    private final Integer maxTokens;

    private HyperParameters(Builder b) {
        this.model = b.model;
        this.temperature = b.temperature;
        this.topP = b.topP;
        this.topK = b.topK;
        this.topA = b.topA;
        this.frequencyPenalty = b.frequencyPenalty;
        this.presencePenalty = b.presencePenalty;
        this.repetitionPenalty = b.repetitionPenalty;
        this.minP = b.minP;
        this.maxTokens = b.maxTokens;
        this.validate();
    }

    private void validate() {
        if (this.temperature < 0.0 || this.temperature > 2.0) {
            throw new IllegalArgumentException("Temperature must be between 0.0 and 2.0");
        }
        if (this.topP < 0.0 || this.topP > 1.0) {
            throw new IllegalArgumentException("Top P must be between 0.0 and 1.0");
        }
        if (this.topK < 0) {
            throw new IllegalArgumentException("Top K must be 0 or greater");
        }
        if (this.topA < 0.0 || this.topA > 1.0) {
            throw new IllegalArgumentException("Top A must be between 0.0 and 1.0");
        }
        if (this.frequencyPenalty < -2.0 || this.frequencyPenalty > 2.0) {
            throw new IllegalArgumentException("Frequency Penalty must be between -2.0 and 2.0");
        }
        if (this.presencePenalty < -2.0 || this.presencePenalty > 2.0) {
            throw new IllegalArgumentException("Presence Penalty must be between -2.0 and 2.0");
        }
        if (this.repetitionPenalty < 0.0 || this.repetitionPenalty > 2.0) {
            throw new IllegalArgumentException("Repetition Penalty must be between 0.0 and 2.0");
        }
        if (this.minP < 0.0 || this.minP > 1.0) {
            throw new IllegalArgumentException("Min P must be between 0.0 and 1.0");
        }
        if (this.maxTokens == null || this.maxTokens < 1) {
            throw new IllegalArgumentException("Max Tokens must be at least 1");
        }
        if (this.model == null || this.model.isEmpty()) {
            throw new IllegalArgumentException("Model is required");
        }
    }

    public void populateConfig(JSONObject config) {
        for (Field field : HyperParameters.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                Object val = field.get(this);
                if (val == null) continue;
                JsonKey keyAnn = field.getAnnotation(JsonKey.class);
                String key = keyAnn != null ? keyAnn.value() : field.getName();
                config.put(key, val);
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClass().getName(), (Throwable)e, (String)("Error mapping Hyperparameter: " + field.getName()));
                throw new RuntimeException("Unable to map Hyperparameter: " + field.getName(), e);
            }
        }
    }

    public static final class Builder {
        private String model;
        private Double temperature;
        private Double topP;
        private Integer topK;
        private Double frequencyPenalty;
        private Double presencePenalty;
        private Double repetitionPenalty;
        private Double minP;
        private Double topA;
        private Integer maxTokens;

        public Builder model(String v) {
            this.model = v;
            return this;
        }

        public Builder temperature(Double v) {
            this.temperature = v;
            return this;
        }

        public Builder topP(Double v) {
            this.topP = v;
            return this;
        }

        public Builder topK(Integer v) {
            this.topK = v;
            return this;
        }

        public Builder topA(Double v) {
            this.topA = v;
            return this;
        }

        public Builder frequencyPenalty(Double v) {
            this.frequencyPenalty = v;
            return this;
        }

        public Builder presencePenalty(Double v) {
            this.presencePenalty = v;
            return this;
        }

        public Builder repetitionPenalty(Double v) {
            this.repetitionPenalty = v;
            return this;
        }

        public Builder minP(Double v) {
            this.minP = v;
            return this;
        }

        public Builder maxTokens(Integer v) {
            this.maxTokens = v;
            return this;
        }

        public HyperParameters build() {
            return new HyperParameters(this);
        }
    }
}

