/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.AgentPromptAbstract;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Message;
import org.joget.ai.agent.model.Messages;
import org.joget.apps.app.dao.FormDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.FormDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.lib.Grid;
import org.joget.apps.form.model.AbstractSubForm;
import org.joget.apps.form.model.Element;
import org.joget.apps.form.model.Form;
import org.joget.apps.form.model.FormContainer;
import org.joget.apps.form.model.FormData;
import org.joget.apps.form.model.FormReferenceDataRetriever;
import org.joget.apps.form.model.FormRow;
import org.joget.apps.form.model.FormRowSet;
import org.joget.apps.form.model.GridInnerDataRetriever;
import org.joget.apps.form.model.Section;
import org.joget.apps.form.service.FormService;
import org.joget.apps.form.service.FormUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.StringUtil;
import org.joget.workflow.model.WorkflowAssignment;

public class FormDataAgentPrompt
extends AgentPromptAbstract {
    public String getName() {
        return "FormDataAgentPrompt";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-file-alt\"></i>";
    }

    @Override
    public String getInfoTemplate() {
        String formLabel = AppPluginUtil.getMessage((String)"app.exportformemailtool.form", (String)this.getClassName(), (String)"messages/agentPlugins");
        String formatLabel = AppPluginUtil.getMessage((String)"formData.format", (String)this.getClassName(), (String)"messages/agentPlugins");
        String label = AppPluginUtil.getMessage((String)"listdata.explanation", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + formLabel + "</dt><dd>${properties.formDefId}</dd><dt>" + formatLabel + "</dt><dd>${properties.format}</dd><dt>" + label + "</dt><dd><pre>${properties.explanation}</pre></dd></dl></div>";
    }

    @Override
    public void generate(AgentLLM llm, LLMConfig config, Messages messages) throws AgentException {
        try {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            WorkflowAssignment wfAssignment = (WorkflowAssignment)this.getProperty("workflowAssignment");
            String primaryKey = this.getPropertyString("recordId");
            if (primaryKey.isEmpty() && wfAssignment != null) {
                AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                primaryKey = appService.getOriginProcessId(wfAssignment.getProcessId());
            }
            Object formData = null;
            if ("json".equalsIgnoreCase(this.getPropertyString("format"))) {
                formData = "```JSON\n" + FormUtil.loadFormDataJson((String)appDef.getAppId(), (String)appDef.getVersion().toString(), (String)this.getPropertyString("formDefId"), (String)primaryKey, (boolean)true, (boolean)true, (boolean)true, (WorkflowAssignment)wfAssignment) + "\n```";
            } else {
                FormDefinitionDao formDefinitionDao = (FormDefinitionDao)AppUtil.getApplicationContext().getBean("formDefinitionDao");
                FormDefinition formDefinition = formDefinitionDao.loadById(this.getPropertyString("formDefId"), appDef);
                if (formDefinition != null) {
                    String json = formDefinition.getJson();
                    formData = this.generateForm(json, primaryKey, wfAssignment);
                }
            }
            if (formData != null && !((String)formData).isEmpty()) {
                messages.add(new Message(Message.Role.SYSTEM, this.getPropertyString("explanation") + "\n\n" + (String)formData));
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            throw new AgentException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateForm(String json, String primaryKey, WorkflowAssignment wfAssignment) {
        FormService formService = (FormService)AppUtil.getApplicationContext().getBean("formService");
        StringBuilder markdown = new StringBuilder();
        FormData formData = new FormData();
        try {
            formData.setAssignment(wfAssignment);
            formData.setPrimaryKeyValue(primaryKey);
            AppUtil.setCurrentAssignment((WorkflowAssignment)wfAssignment);
            Form form = formService.loadFormFromJson(json, formData);
            FormUtil.executeLoadBinders((Element)form, (FormData)formData);
            this.recursivePopulateFormData(markdown, (Element)form, formData, 1);
        }
        finally {
            AppUtil.setCurrentAssignment((WorkflowAssignment)wfAssignment);
        }
        return markdown.toString();
    }

    protected void recursivePopulateFormData(StringBuilder markdown, Element e, FormData formData, int level) {
        boolean isAuthorize = e.isAuthorize(formData);
        if (isAuthorize && !FormUtil.isHidden((Element)e, (FormData)formData)) {
            String label;
            Collection childs = e.getChildren(formData);
            if (e instanceof Form) {
                this.addHeaderLevel(markdown, level++);
                markdown.append("Form Name : ").append(e.getPropertyString("name")).append("\n");
                markdown.append("ID : ").append(formData.getPrimaryKeyValue()).append("\n");
            } else if (e instanceof Section || e instanceof AbstractSubForm) {
                label = e.getPropertyString("label");
                if (!label.isEmpty()) {
                    this.addHeaderLevel(markdown, level++);
                    markdown.append(label).append("\n");
                }
                if (e instanceof AbstractSubForm && !childs.isEmpty()) {
                    childs = ((Element)childs.iterator().next()).getChildren(formData);
                }
            } else if (e instanceof Grid || e instanceof GridInnerDataRetriever) {
                FormRowSet rowSet = formData.getLoadBinderData(e);
                if (!rowSet.isEmpty()) {
                    this.generateTable(markdown, e, rowSet);
                }
            } else if (!(e instanceof FormContainer) && !(label = e.getPropertyString("label")).isEmpty()) {
                markdown.append(label).append(" : ");
                if (e.getOptionsBinder() != null || e instanceof FormReferenceDataRetriever) {
                    String[] values = FormUtil.getElementPropertyValues((Element)e, (FormData)formData);
                    if (values.length > 0) {
                        Collection options;
                        HashMap<String, String> optionMap = new HashMap<String, String>();
                        if (e.getOptionsBinder() != null) {
                            options = FormUtil.getElementPropertyOptionsMap((Element)e, (FormData)formData);
                            for (Map opt : options) {
                                optionMap.put((String)opt.get("value"), (String)opt.get("label"));
                            }
                        } else if (e instanceof FormReferenceDataRetriever && (options = ((FormReferenceDataRetriever)e).loadFormRows(values, formData)) != null) {
                            String idField = e.getPropertyString("idField");
                            String displayField = e.getPropertyString("displayField");
                            for (FormRow r : options) {
                                optionMap.put(r.getProperty(idField), r.getProperty(displayField));
                            }
                        }
                        boolean isFirst = true;
                        for (String v : values) {
                            String l;
                            if (!isFirst) {
                                markdown.append(", ");
                            }
                            if ((l = (String)optionMap.get(v)) != null && !l.isEmpty()) {
                                markdown.append(l).append(" (").append(v).append(")");
                                continue;
                            }
                            markdown.append(v);
                        }
                    }
                } else {
                    String value = FormUtil.getElementPropertyValue((Element)e, (FormData)formData);
                    markdown.append(value);
                }
                markdown.append("\n");
            }
            if (childs != null) {
                for (Element c : childs) {
                    this.recursivePopulateFormData(markdown, c, formData, level);
                }
            }
        }
    }

    protected void addHeaderLevel(StringBuilder markdown, int level) {
        markdown.append("\n");
        for (int i = 0; i < level; ++i) {
            markdown.append("#");
        }
        markdown.append(" ");
    }

    protected void generateTable(StringBuilder markdown, Element e, FormRowSet rows) {
        String label;
        if (!rows.isMultiRow()) {
            String gridValue = ((FormRow)rows.get(0)).getProperty(e.getPropertyString("id"));
            rows = FormUtil.jsonToFormRowSet((String)gridValue);
        }
        if (!(label = e.getPropertyString("label")).isEmpty()) {
            markdown.append(label).append(" :\n");
        }
        ArrayList<String> cols = new ArrayList<String>();
        StringBuilder seperator = new StringBuilder();
        markdown.append("| ");
        seperator.append("| ");
        Object optionProperty = e.getProperty("options");
        if (optionProperty != null && optionProperty instanceof Collection) {
            for (Object opt : (ArrayList)optionProperty) {
                Map optMap = (Map)opt;
                Object v = optMap.get("value");
                Object l = optMap.get("label");
                markdown.append(StringUtil.stripAllHtmlTag((String)l.toString()));
                markdown.append(" | ");
                seperator.append(" --- | ");
                cols.add(v.toString());
            }
        }
        markdown.append("\n");
        seperator.append("\n");
        markdown.append(seperator.toString());
        for (FormRow r : rows) {
            markdown.append("| ");
            for (String c : cols) {
                markdown.append(StringUtil.stripAllHtmlTag((String)r.getProperty(c)));
                markdown.append(" | ");
            }
            markdown.append("\n");
        }
    }
}

