/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.lib;

import org.joget.ai.agent.model.AgentEnhancerAbstract;
import org.joget.ai.agent.model.AgentException;
import org.joget.ai.agent.model.AgentLLM;
import org.joget.ai.agent.model.LLMConfig;
import org.joget.ai.agent.model.Response;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;

public class CodeExtractorAgentEnhancer
extends AgentEnhancerAbstract {
    public String getName() {
        return "CodeExtractorAgentEnhancer";
    }

    public String getVersion() {
        return "8.1-SNAPSHOT";
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/agentPlugins");
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)("/properties/agent/" + this.getName() + ".json"), null, (boolean)false, (String)"messages/agentPlugins");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-code\"></i>";
    }

    @Override
    public String getInfoTemplate() {
        String label = AppPluginUtil.getMessage((String)"beanshellprompt.purpose", (String)this.getClassName(), (String)"messages/agentPlugins");
        return "<div><dl><dt>" + label + "</dt><dd>${properties.purpose}</dd></dl></div>";
    }

    @Override
    public void enhance(AgentLLM llm, LLMConfig config, Response response) throws AgentException {
        String newRespond = response.getContent();
        try {
            if (newRespond != null && !newRespond.isEmpty() && newRespond.contains("```")) {
                if ((newRespond = newRespond.substring(newRespond.indexOf("\n", newRespond.indexOf("```")) + 1)).trim().isEmpty()) {
                    newRespond = response.getContent();
                }
                if (newRespond.indexOf("```") > 0) {
                    newRespond = newRespond.substring(0, newRespond.indexOf("```"));
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        response.setContent(newRespond);
    }
}

